/*******************************************************
Filename		:  FA_BIO_RESULT_index.sql
Release 		:  c2.0
SIR			:  1495
Description		:  create indexes for the FA_BIOLOGICAL_RESULT fact table.
Author			:  Christine Tsang
Date			:  08/11/2003 -- added bitmap index to fk_community_sampled -JW
	01/16/04 - SIR 1586 Moved connect string to master install script -JW
	01/26/04 - SIR 1571 Create index on FK_STN_ACT_PT -JW
	09/27/2004 - SIR 1638. Create index on fk_statn_types -GT.
	06/07/2005 - SIR1706.  update indexes with hydrologic_unit_code with generated_huc. - GT
Comments		:  
**********************************************************/

spool FA_BIOLOGICAL_RESULT_index.log

--check where ibr_date was created before
create index ibr_date on FA_BIOLOGICAL_RESULT(fk_date_act_start)
tablespace storetindx
storage (initial 5M next 5M) nologging;

create index ibr_activity_isn on FA_BIOLOGICAL_RESULT(activity_isn)
tablespace storetindx
storage (initial 5M next 5M) nologging;


--FK INDEXES
create bitmap index ibr_org1 on FA_BIOLOGICAL_RESULT(fk_org)
tablespace storetindx
storage (initial 5M next 5M) nologging;

/**
--only 429 currently used, changed to bitmap 2-25
--was deleted due to performance problems with project 3-28
create bitmap index ibr_char on FA_BIOLOGICAL_RESULT(fk_char)
tablespace storetindx
storage (initial 50m next 50m);
**/

--changed to bitmap 2-25
create bitmap index ibr_geo1 on FA_BIOLOGICAL_RESULT(fk_geo_state)
tablespace storetindx
storage(initial 5M next 5M) nologging;

create index ibr_geo2 on FA_BIOLOGICAL_RESULT(fk_geo_county)
tablespace storetindx
storage(initial 5M next 5M) nologging;

create index ibr_db_cat on FA_BIOLOGICAL_RESULT(fk_db_cat)
tablespace storetindx
storage(initial 5M next 5M) nologging;

create index ibr_gen_db_cat on FA_BIOLOGICAL_RESULT(fk_gen_db_cat)
tablespace storetindx
storage(initial 5M next 5M) nologging;
--use to be created in another script
create index ibr_station on FA_BIOLOGICAL_RESULT(fk_station)
tablespace storetindx
storage(initial 5M next 5M) nologging;


--ADDITIONAL COLUMN INDEXES
create index ibr_huc on FA_BIOLOGICAL_RESULT(generated_huc)
tablespace storetindx
storage(initial 5M next 5M) nologging;

--changed to bitmap 1/28
create bitmap index ibr_oid on                             
FA_BIOLOGICAL_RESULT(organization_id)                   
tablespace storetindx                             
storage(initial 5M next 5M) nologging; 

create bitmap index ibr_intent on                             
FA_BIOLOGICAL_RESULT(fk_act_intent)                   
tablespace storetindx                             
storage(initial 5M next 5M) nologging; 

create bitmap index ibr_community on                             
FA_BIOLOGICAL_RESULT(fk_community_sampled)                   
tablespace storetindx                             
storage(initial 5M next 5M) nologging; 

--delete independent lat and long indexes?
create index ibr_lat_long on 
FA_BIOLOGICAL_RESULT(stn_latitude,stn_longitude)
tablespace storetindx
storage(initial 5M next 5M) nologging;

--MULTI-DIMENSIONAL INDEXES
/**
create index ibr_lat_long_medium on 
FA_BIOLOGICAL_RESULT(stn_latitude,stn_longitude,fk_act_medium)
tablespace storetindx
storage(initial 50m next 50m);
**/

create index ibr_date_lat_long on 
FA_BIOLOGICAL_RESULT(fk_date_act_start,stn_latitude,stn_longitude)
tablespace storetindx
storage(initial 5M next 5M) nologging;

create index ibr_char_date_lat_long on 
FA_BIOLOGICAL_RESULT(fk_char,fk_date_act_start,stn_latitude,stn_longitude)
tablespace storetindx
storage(initial 5M next 5M) nologging;


create index ibr_state_date_char on 
FA_BIOLOGICAL_RESULT(fk_geo_state,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 5M next 5M) nologging;

create index ibr_county_date_char on 
FA_BIOLOGICAL_RESULT(fk_geo_county,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 5M next 5M) nologging;

create index ibr_huc_date_char on 
FA_BIOLOGICAL_RESULT(generated_huc,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 5M next 5M) nologging;

--added from performance_tuning script
create index ibr_pk_date_char on 
FA_BIOLOGICAL_RESULT(pk_isn,fk_date_act_start,fk_char)
tablespace storetindx
storage(initial 5M next 5M) nologging;

create index ibr_pk_char on 
FA_BIOLOGICAL_RESULT(pk_isn,fk_char)
tablespace storetindx
storage(initial 5M next 5M) nologging;

--Added 1-26 for SIR 1571
create index ibr_stn_act_pt on FA_BIOLOGICAL_RESULT(fk_stn_act_pt)
tablespace storetindx
storage(initial 5M next 5M) nologging;

--SIR 1638
create bitmap index ibr_statn_types on FA_BIOLOGICAL_RESULT(fk_statn_types)
tablespace storetindx
storage(initial 5M next 5M) nologging;

spool off;